IF EXISTS( SELECT * FROM SYS.procedures
			WHERE NAME = 'P_EST_NF_ENT_IT_PRECO_TRANSFERENCIA_FILIAIS')
    BEGIN
        DROP PROCEDURE P_EST_NF_ENT_IT_PRECO_TRANSFERENCIA_FILIAIS;
    END;
GO

--P_EST_NF_ENT_IT_PRECO_TRANSFERENCIA_FILIAIS 1,1,'2019-08-18',0

CREATE PROCEDURE P_EST_NF_ENT_IT_PRECO_TRANSFERENCIA_FILIAIS (@CD_EMP			INT 
																, @CD_CONFIG	INT  
																, @DATA_ANALISE DATE = NULL
																, @CD_PROD_PAR	INT      = 0 
																, @ANALISE		TINYINT =0)
WITH ENCRYPTION
AS
     SET NOCOUNT ON;
     DECLARE @FLAG_TIPO_PRECO INT;

	 IF @DATA_ANALISE IS NULL
		SET @DATA_ANALISE = DATEADD(DAY, -31, GETDATE());

	IF @DATA_ANALISE = CONVERT(DATE, GETDATE())
		SET @DATA_ANALISE = DATEADD(DAY, -1, GETDATE());

     SET @FLAG_TIPO_PRECO = 0;
	 DECLARE @CD_FILIAL INT,@CD_PROD INT, @CD_CTR INT
	 DECLARE @DT_ENT	DATE, @HR_ENT VARCHAR(20);
     DECLARE @FLAG_PRECO_LIQUIDO INT;
     
	 ----------------------------------------------------------------------------------------------------------------
     PRINT 'Line 32 '+CONVERT(VARCHAR, GETDATE(), 108);

     CREATE TABLE #RSPRODUTOPROC(
				  CD_EMP                INT
				, CD_FILIAL             INT
				, CD_CONFIG             INT
				, CD_PROD               INT
				, DS_PROD               VARCHAR(250)
				, CD_TRIB_FC            VARCHAR(4)
				, VLR_IT                MONEY
				, VLR_DESC              MONEY
				, VLR_ICMS              MONEY
				, VLR_ICMS_SUBST        MONEY
				, VLR_ICMS_RET          MONEY
				, VLR_PROD_TRANSF       MONEY
				, VLR_PROD_TRANSF_ATUAL MONEY
				, CD_NF                 INT
				, NR_NF                 INT
				, NM_FORNECEDOR         VARCHAR(250)
				, ALIQ_ICMS_ENTRADA     MONEY
				, VLR_IPI               MONEY
				, VLR_OUTRAS_DESPESAS   MONEY
				, VLR_CUSTO_IT				MONEY
			);

     CREATE TABLE #RsFiliaisProc ( CD_EMP    INT , CD_FILIAL INT );
	 PRINT 'Line 58 '+CONVERT(VARCHAR, GETDATE(), 108);

	 ----------------------------------------------------------------------------------------------------------------
     INSERT INTO #RsFiliaisProc
		SELECT
				CD_EMP
				, CD_FILIAL
		FROM
				(SELECT DISTINCT
						CD_EMP
						, CD_CTR_DEPO
						, CD_FILIAL
				FROM
				(SELECT
						CD_EMP
						, CD_CTR_DEPO
						, CD_FILIAL
					FROM V_PRC_FILIAL_RELACAO_DEPOSITOS D
					UNION
					SELECT
						CD_EMP
						, CD_CTR_DEPO
						, CD_FILIAL
					FROM PRC_FILIAL_DEPOSITO_PRC_FILIAL F) AS TBL) D
				INNER JOIN GLB_CONFIG_PRECO_RESSUP C ON 
				D.CD_CTR_DEPO = C.CD_CTR_DEPO
		WHERE C.CD_CONFIG = 1;		 

		SELECT
			@FLAG_TIPO_PRECO = ISNULL(FLAG_TIPO_PRECO, 0)
			, @FLAG_PRECO_LIQUIDO = ISNULL(FLAG_PRECO_LIQUIDO, 0)
		FROM
			GLB_CONFIG_PRECO_RESSUP
		WHERE CD_CONFIG = @cd_config;
----------------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #ProdEntrada
	(CD_PROD INT, DT_ENT DATE, HR_ENT VARCHAR(12) COLLATE SQL_Latin1_General_CP1_CI_AS)

----------------------------------------------------------------------------------------------------------------------------------------------
		
		PRINT 'Line 97 '+CONVERT(VARCHAR, GETDATE(), 108);

		INSERT INTO #ProdEntrada
		SELECT I.CD_PROD
			, MAX(C.DT_ENT) DT_ENT 
			, MAX(C.HR_ENT) HR_ENT
		FROM
			V_EST_NF_ENT_CAB C
			INNER JOIN EST_NF_ENT_IT I ON C.CD_EMP = I.CD_EMP
										AND C.CD_FILIAL = I.CD_FILIAL
										AND C.CD_NF = I.CD_NF
			INNER JOIN #RsFiliaisProc F ON 
				C.CD_EMP	= F.CD_EMP
			AND C.CD_FILIAL = F.CD_FILIAL
		WHERE 
				C.CD_EMP = 1
			AND C.TP_MOV = 0
			AND C.DT_ENT > @DATA_ANALISE
			AND C.CD_ORIG NOT IN  (SELECT PRC_FILIAL_PG_FORN.CD_FORN
										FROM 
											PRC_FILIAL_PG_FORN
											INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
											PRC_FILIAL_PG_FORN.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
											PRC_FILIAL_PG_FORN.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL) 
		GROUP BY CD_PROD;
		 
 ----------------------------------------------------------------------------------------------------------------------
	  PRINT 'Line 125 '+CONVERT(VARCHAR, GETDATE(), 108);

	INSERT INTO #RSPRODUTOPROC ( CD_EMP, CD_FILIAL, CD_CONFIG, CD_PROD, DS_PROD, CD_TRIB_FC
							, VLR_IT, VLR_DESC, VLR_ICMS, VLR_ICMS_SUBST, VLR_ICMS_RET, VLR_PROD_TRANSF
							, VLR_PROD_TRANSF_ATUAL, CD_NF, NR_NF, NM_FORNECEDOR, ALIQ_ICMS_ENTRADA, VLR_IPI, VLR_OUTRAS_DESPESAS, VLR_CUSTO_IT)
	SELECT  
		C.CD_EMP
		, C.CD_FILIAL
		, @CD_CONFIG
		, I.CD_PROD
		, P.DS_PROD
		, T.CD_TRIB_FC
		, I.VLR_IT
		, CASE WHEN I.QT_IT = 0 THEN 0
			ELSE I.VLR_DESC / I.QT_IT END AS VLR_DESC
		, CASE WHEN I.QT_IT = 0 THEN 0
			ELSE I.VLR_ICMS_IT / I.QT_IT END AS VLR_ICMS_IT
		, CASE WHEN I.QT_IT = 0 THEN 0
			ELSE I.VLR_ICMS_SUBS / I.QT_IT END AS VLR_ICMS_SUBS
		, CASE WHEN I.QT_IT = 0 THEN 0
			ELSE(ISNULL(I.VLR_ICMS_RET, 0) / I.QT_IT) END AS VLR_ICMS_RET
		, CASE WHEN I.QT_IT = 0 THEN 0
			ELSE CASE
					WHEN SUBS_TRIB_ANT = 1 THEN CASE
													WHEN ISNULL(I.VLR_BASE_ICMS_OP, 0) > 0 THEN CASE WHEN @FLAG_TIPO_PRECO = 0 THEN --ICMS ST
																								CASE
																									WHEN @FLAG_PRECO_LIQUIDO = 0 THEN --Preco liquido
																								((I.VLR_IT - (I.VLR_DESC / I.QT_IT)) - (ISNULL(I.VLR_ICMS_RET, 0) / I.QT_IT)) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
																									ELSE(I.VLR_IT - (ISNULL(I.VLR_ICMS_RET, 0) / I.QT_IT)) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
																								END
																									ELSE --Preco liquido + valor icms retido
																									CASE
																										WHEN @FLAG_PRECO_LIQUIDO = 0 THEN --Preco liquido
																									(I.VLR_IT - (I.VLR_DESC / I.QT_IT)) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
																										ELSE I.VLR_IT
																									END
																								END
													ELSE CASE
																WHEN @FLAG_PRECO_LIQUIDO = 0 THEN --Preco liquido
															(I.VLR_IT - (I.VLR_DESC / I.QT_IT)) + (I.VLR_IPI / I.QT_IT) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
																ELSE I.VLR_IT + (I.VLR_IPI / I.QT_IT) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
															END
												END
					ELSE CASE
								WHEN @FLAG_TIPO_PRECO = 0 THEN --Nao ICMS ST
							CASE
								WHEN @FLAG_PRECO_LIQUIDO = 0 THEN --Preco liquido
							(I.VLR_IT - (I.VLR_DESC / I.QT_IT)) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
								ELSE I.VLR_IT + (I.VLR_IPI / I.QT_IT) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
							END
								ELSE --Preco liquido + valor substituicao
								CASE
									WHEN @FLAG_PRECO_LIQUIDO = 0 THEN --Preco liquido
								(I.VLR_IT - (I.VLR_DESC / I.QT_IT)) + (I.VLR_ICMS_SUBS / I.QT_IT) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
									ELSE I.VLR_IT + (I.VLR_ICMS_SUBS / I.QT_IT) + (I.VLR_IPI / I.QT_IT) + (I.VLR_OUTRAS_DESPESAS / I.QT_IT)
								END
							END
				END
		END
		, 0
		, I.CD_NF
		, C.NR_NF
		, C.NM_ORIG
		, CASE
			WHEN ISNULL(I.PERC_ICMS_OP, 0) > 0 THEN I.PERC_ICMS_OP
			WHEN ISNULL(I.PERC_ICMS_RET, 0) > 0 THEN I.PERC_ICMS_RET
			ELSE I.ALIQ_ICMS
		END AS ALIQ_ICMS_ENTRADA
		, CASE
			WHEN I.QT_IT = 0 THEN 0
			ELSE(I.VLR_IPI / I.QT_IT)
		END AS VLR_IPI
		, CASE
			WHEN I.QT_IT = 0 THEN 0
			ELSE(I.VLR_OUTRAS_DESPESAS / I.QT_IT)
		END AS VLR_OUTRAS_DESPESAS
		,I.VLR_PRC_CUSTO

	FROM
		V_EST_NF_ENT_CAB C
		INNER JOIN EST_NF_ENT_IT I ON C.CD_EMP = I.CD_EMP
									AND C.CD_FILIAL = I.CD_FILIAL
									AND C.CD_NF = I.CD_NF
		INNER JOIN EST_PROD P ON I.CD_EMP = P.CD_EMP
								AND I.CD_PROD = P.CD_PROD
		INNER JOIN EST_TRIB T ON I.CD_TRIB = T.CD_TRIB

		JOIN #ProdEntrada B on 
			C.DT_ENT  = b.DT_ENT 
		and i.DT_ENT  = b.DT_ENT 
		AND C.HR_ENT COLLATE SQL_Latin1_General_CP1_CI_AS  = b.HR_ENT
		AND I.CD_PROD = b.CD_PROD
	WHERE 
		C.CD_EMP = @CD_EMP                
		AND C.TP_MOV = 0
		AND C.DT_ENT >@DATA_ANALISE
		AND C.CD_ORIG NOT IN  (SELECT PRC_FILIAL_PG_FORN.CD_FORN
									FROM 
										PRC_FILIAL_PG_FORN
										INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON 
										PRC_FILIAL_PG_FORN.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
										PRC_FILIAL_PG_FORN.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL) 
										
	PRINT 'Line 228 '+CONVERT(VARCHAR, GETDATE(), 108);
 -------------------------------------------------------------------------------------------------------------------------------
     --CREATE UNIQUE CLUSTERED INDEX #ix_#RSPRODUTOPROC ON #RSPRODUTOPROC(CD_PROD, CD_FILIAL, CD_EMP);
	
	DELETE FROM A
	FROM 
	 #RSPRODUTOPROC A
	 JOIN (SELECT
            P.CD_EMP
          , P.CD_FILIAL
          , P.CD_PROD
         , MAX(CD_NF) CD_NF
          , COUNT(*) QTDE
     FROM
          #RSPRODUTOPROC p
	GROUP BY 
		    P.CD_EMP
          , P.CD_FILIAL
          , P.CD_PROD       
	HAVING  COUNT(*) > 1) B ON 
	A.CD_EMP	= B.CD_EMP  AND 
    A.CD_FILIAL	= B.CD_FILIAL AND
    A.CD_PROD   = B.CD_PROD
    AND A.CD_NF <> B.CD_NF  
	 
	CREATE UNIQUE CLUSTERED INDEX #ix_#RSPRODUTOPROC ON #RSPRODUTOPROC(CD_PROD, CD_FILIAL, CD_EMP);


IF @ANALISE =1
BEGIN	 
										
	PRINT 'Line 259 '+CONVERT(VARCHAR, GETDATE(), 108);
	SELECT
		P.CD_EMP
		, P.CD_FILIAL
		, P.CD_CONFIG
		, P.CD_PROD
		, p.DS_PROD
		, P.CD_TRIB_FC
		, P.VLR_IT
		, P.VLR_DESC
		, P.VLR_ICMS
		, P.VLR_ICMS_SUBST
		, P.VLR_ICMS_RET
		, P.VLR_PROD_TRANSF
		, ISNULL(G.VLR_TRANSF, 0) AS VLR_PROD_TRANSF_ATUAL
		, P.CD_NF
		, P.NR_NF
		, P.NM_FORNECEDOR 
		, p.ALIQ_ICMS_ENTRADA
		, p.VLR_IPI
		, p.VLR_OUTRAS_DESPESAS
		, P.VLR_CUSTO_IT
	FROM
		#RSPRODUTOPROC p
		LEFT OUTER JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD g ON p.CD_EMP = g.CD_EMP
															AND p.CD_PROD = g.CD_PROD
															AND p.CD_CONFIG = g.CD_CONFIG;
   

END 
ELSE
BEGIN
	PRINT 'Line 291 '+CONVERT(VARCHAR, GETDATE(), 108);
	/****************************************************************************************************************************/   
	-- GRAVACAO 
	/****************************************************************************************************************************/   

	UPDATE A
	SET
		VLR_TRANSF			= P.VLR_PROD_TRANSF
		,CD_USU				= 1
		,DT_ULT_ALT			= GETDATE()
		,ALIQ_ICMS_ENTRADA	= P.ALIQ_ICMS_ENTRADA
		,VLR_CUSTO_IT		= P.VLR_CUSTO_IT
	FROM
		#RSPRODUTOPROC P
		JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD A ON	P.CD_EMP	= A.CD_EMP
											AND P.CD_PROD	= A.CD_PROD
											AND P.CD_CONFIG = A.CD_CONFIG
	WHERE
			p.CD_CONFIG	=@CD_CONFIG
		AND p.CD_EMP		=@CD_EMP;
	
     -------------------------------------------------------------------------------------------------------------------
	
	INSERT INTO GLB_CONFIG_PRECO_RESSUP_EST_PROD	(CD_CONFIG		,CD_EMP		,CD_PROD		,VLR_TRANSF		,CD_USU
														,DT_CAD		,DT_ULT_ALT		,ALIQ_ICMS_ENTRADA		,VLR_CUSTO_IT)
     SELECT
          
		    P.CD_CONFIG
		  , P.CD_EMP
          , P.CD_PROD

          , P.VLR_PROD_TRANSF
          , 1 CD_USU
          , GETDATE()
          , NULL 
          , p.ALIQ_ICMS_ENTRADA
          , P.VLR_CUSTO_IT
     FROM
          #RSPRODUTOPROC p
          LEFT OUTER JOIN GLB_CONFIG_PRECO_RESSUP_EST_PROD g ON p.CD_EMP = g.CD_EMP
                                                                AND p.CD_PROD = g.CD_PROD
                                                                AND p.CD_CONFIG = g.CD_CONFIG
	 where
		G.CD_EMP IS NULL;
		
	/**********************************************************************************************/

	SET @CD_CTR = ISNULL((SELECT MAX(CD_CTR) +1 FROM PRC_EMP_PROC_PRECO_TRANSFERENCIA),1);
	IF EXISTS(SELECT * FROM #RSPRODUTOPROC)
	BEGIN
		INSERT INTO PRC_EMP_PROC_PRECO_TRANSFERENCIA (CD_CTR, CD_EMP, CD_CONFIG, DT_PROC, DT_CAD, CD_USU, FLAG_PROC_PROD)
		SELECT
			@CD_CTR 
			, @CD_EMP
			, @CD_CONFIG
			, @DATA_ANALISE 
			, GETDATE() DT_CAD
			, 1 CD_USU
			, 1 FLAG_PROC_PROD
	
		INSERT INTO PRC_EMP_PROC_PRECO_TRANSFERENCIA_CPL (CD_CTR,CD_EMP,CD_FILIAL,CD_NF)
		SELECT DISTINCT
			  @CD_CTR  CD_CTR
			, P.CD_EMP
			, P.CD_FILIAL
			, P.CD_NF	
		 FROM 
			 #RSPRODUTOPROC p
	END

	/**********************************************************************************************/
END